local t = Def.ActorFrame{};

local function GetDifficulty(pn)
	local IsStepsOrTrail
	if GetCurrentSteps(pn) == nil then
		return "Difficulty_Edit"
	else
		IsStepsOrTrail = GetCurrentStepsOrTrail(pn)
	end
	local GetSteps = IsStepsOrTrail
	local difficulty = GetSteps:GetDifficulty()
	return difficulty
end

local function CompareBothDifficulties()
	local DiffP1 = GetDifficulty(PLAYER_1)
	local DiffP2 = GetDifficulty(PLAYER_2)
	local AreSame
	if DiffP1 == DiffP2 then
		AreSame = true
	else
		AreSame = false
	end
	return AreSame
end

local function GetCurrentPercentScore(pn)
	local pss = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats(pn);
	local DP = pss:GetPercentDancePoints()
	return DP
end

local function CompareBothScores()
	local ScoreP1 = GetCurrentPercentScore(PLAYER_1)
	local ScoreP2 = GetCurrentPercentScore(PLAYER_2)
	local WhoWon
	if ScoreP1 > ScoreP2 then
		WhoWon = "P1"
	else
		WhoWon = "P2"
	end
	return WhoWon
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(draworder,1);
		LoadFont("_PercentScore")..{
			BeginCommand=cmd(y,Top()+48;zoom,1;valign,0;maxwidth,178;shadowlength,3);
			InitCommand=function(self)
				if pn == PLAYER_1 then self:x(CenterX()-226) else self:x(CenterX()+226) end
				if GetCurrentPercentScore(pn) == 1 then
					self:settext("100.00");
				else
					self:settext(string.gsub(FormatPercentScore(GetCurrentPercentScore(pn)),"%%",""))
				end
				if CompareBothDifficulties() == true then
					if CompareBothScores() == ToEnumShortString(pn) then
						self:diffuse(White())
					else
						self:diffuse(ColorMidTone(White()))
					end
				end
			end,
		},
	};
end

local function FullComboSymbol(pn,tns)
	local PlayedSS = STATSMAN:GetPlayedStageStats(1)
	local FCS = PlayedSS:GetPlayerStageStats(pn):FullComboOfScore(tns)
	return FCS
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		LoadFont("Common Normal")..{
			BeginCommand=cmd(x,CenterX()-226;y,Top()+26;zoom,0.4;shadowlength,1;valign,0);
			InitCommand=function(self)
				if pn == PLAYER_1 then self:x(CenterX()-226) else self:x(CenterX()+226) end
				local dColor, text
				if FullComboSymbol(pn,9) == true then
					dColor = jColors[1]
					text = "PERFECT FULL COMBO"
				elseif FullComboSymbol(pn,8) == true then
					dColor = jColors[2]
					text = "PERFECT FULL COMBO"
				elseif FullComboSymbol(pn,7) == true then
					dColor = jColors[3]
					text = "GREAT FULL COMBO"
				else
					dColor = "#FFFFFF"
					text = ""
				end
				self:settext(text);
				(cmd(diffuseshift;effectclock,'beat';effectcolor1,color( "0.8,0.95,1,1" );effectcolor2,color(dColor)))(self);
			end
		};
	};
end

return t